-- Blog Database Schema
-- 
-- This creates the complete database structure for the blog system
-- including users, posts, and categories tables with all necessary
-- relationships and constraints.

CREATE DATABASE IF NOT EXISTS yujbjplf_blog;
USE yujbjplf_blog;

CREATE TABLE `announcements` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `type` enum('info','warning','success','error') DEFAULT 'info',
  `status` enum('active','inactive') DEFAULT 'inactive',
  `show_on_home` tinyint(1) DEFAULT 1,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `slug` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `slug`, `description`, `created_at`) VALUES
(1, 'News', 'news', 'Latest news and updates', '2025-09-10 03:45:35'),
(2, 'Articles', 'articles', 'In-depth articles and analysis', '2025-09-10 03:45:35'),
(3, 'Journals', 'journals', 'Personal journals and experiences', '2025-09-10 03:45:35'),
(4, 'CIPS L5', 'cips-l5', 'This is a model answer, questions are much more \r\nopen so your response may be completely different', '2025-09-10 04:26:09'),
(5, 'Clite', 'clite', 'Muta', '2025-11-05 06:41:19'),
(6, 'A Stores Management Training', 'a-stores-management-training', 'Goood management', '2025-11-05 16:22:19'),
(7, 'SOPs', 'sops', 'Standard operating procedures', '2025-11-06 15:47:39');

-- --------------------------------------------------------

--
-- Table structure for table `posts`
--

CREATE TABLE `posts` (
  `id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `excerpt` text DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `author_id` int(11) DEFAULT NULL,
  `status` enum('draft','published') DEFAULT 'draft',
  `featured_image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `manual_author_name` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `posts`
--

INSERT INTO `posts` (`id`, `title`, `slug`, `content`, `excerpt`, `category_id`, `author_id`, `status`, `featured_image`, `created_at`, `updated_at`, `manual_author_name`) VALUES
(1, 'Welcome to Our Blog', 'welcome-to-our-blog', '<p>Welcome to our platform! This is where we\'ll share news, articles, and journals.</p><p>Stay tuned for more exciting content.</p><p><br></p>', 'Welcome to our platform! This is where we\'ll share news, articles, and journals.Stay tuned for more exciting content.', 1, 1, 'published', NULL, '2025-09-10 03:45:35', '2025-09-10 13:18:54', NULL),
(2, 'Getting Started with PHP', 'getting-started-with-php', '<p>PHP is a powerful server-side scripting language that\'s perfect for web development.</p><p>In this article, we\'ll explore the basics of PHP programming.</p>', 'Learn the fundamentals of PHP programming in this comprehensive guide.', 2, 1, 'published', NULL, '2025-09-10 03:45:35', '2025-09-10 03:45:35', NULL),
(3, 'Explain 5 different metaphors that can be used to describe an organisation', 'explain-5-different-metaphors-that-can-be-used-to-describe-an-organisation', '<p class=\"MsoListParagraphCxSpFirst\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">A ‘metaphor’\r\ncan be described as a figure of speech in which an object or action can be used\r\nto describe a concept – the word or phrase used will be figurative and not\r\nliteral.</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">Metaphors are\r\ncommonly used to describe an organisation include: -</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">1) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Machine</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin;font-weight:\r\nnormal\"> = In other words, a system to be managed (most common metaphor)</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">2) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Organism</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin;font-weight:\r\nnormal\"> = which likens an organisation to an organic, living, or biological\r\n‘being’</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">3) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Brain</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin;font-weight:\r\nnormal\"> = describes and organisation as ‘intelligent and able to learn’</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">4) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Culture</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin;font-weight:\r\nnormal\"> = Which sees an organisation as an entity with an identity shaped by\r\nritual and symbolism</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">5) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Political\r\nSystem</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;\r\nmso-ascii-theme-font:minor-latin;mso-hansi-theme-font:minor-latin;mso-bidi-theme-font:\r\nminor-latin;font-weight:normal\"> = equates organisation as places filled with\r\ndiversity of conflicts and power (stakeholder theories)</span></strong></p><p class=\"MsoListParagraphCxSpMiddle\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">6) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Psychic\r\nPrison</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;\r\nmso-ascii-theme-font:minor-latin;mso-hansi-theme-font:minor-latin;mso-bidi-theme-font:\r\nminor-latin;font-weight:normal\"> = sees individuals within an organisation as\r\nrepressed, controlled or trapped.</span></strong></p><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p><p class=\"MsoListParagraphCxSpLast\"><strong><span lang=\"EN-GB\" style=\"font-family:\r\n&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;mso-hansi-theme-font:\r\nminor-latin;mso-bidi-theme-font:minor-latin;font-weight:normal\">7) </span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;mso-ascii-theme-font:minor-latin;\r\nmso-hansi-theme-font:minor-latin;mso-bidi-theme-font:minor-latin\">Instrument of\r\nDomination</span></strong><strong><span lang=\"EN-GB\" style=\"font-family:&quot;Calibri&quot;,sans-serif;\r\nmso-ascii-theme-font:minor-latin;mso-hansi-theme-font:minor-latin;mso-bidi-theme-font:\r\nminor-latin;font-weight:normal\"> which are exploitative and powerful<o:p></o:p></span></strong></p>', 'A ‘metaphor’\r\ncan be described as a figure of speech in which an object or action can be used\r\nto describe a concept – the word or phrase used...', 4, 1, 'published', NULL, '2025-09-10 04:51:33', '2025-09-10 04:52:54', NULL),
(5, 'Discuss the factors that influence psychological contract and how an employer can protect it', 'discuss-the-factors-that-influence-psychological-contract-and-how-an-employer-can-protect-it', '<p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">The term\r\n\'psychological contract\' refers to individuals\' expectations, beliefs, ambitions\r\nand obligations, as perceived by the employer and the worker.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">The\r\npsychological contract concerns the intangible aspects of a person’s role\r\nwithin and organisation, it stands outside of the written terms and conditions\r\nof employment, in that it relates more to the unwritten agreement between an\r\nemployee and their employer that describes the informal commitments,\r\nexpectations and understandings that make up their relationship.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">In essence\r\nit outlines commonly understood ‘expectations’ that aren’t in the legal\r\nemployment contract such as: -<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l1 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">a.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">For the employee:</span></b><span lang=\"EN-GB\">\r\nit would deal with the employee’s feelings and expectations in relation to job\r\nsecurity, career progression, development opportunities, fair pay and benefits\r\nand expected support. <o:p></o:p></span></p><p class=\"MsoListParagraphCxSpLast\" style=\"margin-left:54.0pt;mso-add-space:auto;\r\ntext-indent:-18.0pt;mso-list:l1 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">b.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">For the manager:</span></b><span lang=\"EN-GB\">\r\nThey would have expectations and attitudes around expected timeliness, dress\r\ncode, respect, and attitude.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">The\r\npsychological contract is something which develops over time, through customs\r\nand practice and is built on the actions of both parties (manager and employee)\r\nand over time it sets out how people behave (e.g., whether turning up late is\r\nacceptable or not).&nbsp; Individuals can\r\ninadvertently fall foul to such practices by not fitting in, and sometimes\r\nthese cultures can be regarded as toxic.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">Often\r\nimprecise and rarely spoken, it can often be simply inferred, and expectations\r\ncan be hard to pin down and even harder to enforce if expectations are not made\r\nclear.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">Factors\r\nwhich can influence the phycological contract include; a person’s experience in\r\nprevious employment, the recruitment process, 121s (or lack thereof), other\r\nmanagers / teams within organisation, or public statements made by the company.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">It is\r\nimportant to cultivate a healthy psychological contract via: -<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Employer brand</span></b><span lang=\"EN-GB\">\r\n– being open about attitudes to e.g. The environment and society, flexible\r\nworking, diversity etc, can help to cultivate pride and loyalty among a\r\nworkforce.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Communication</span></b><span lang=\"EN-GB\">\r\n– clear open and honest communication promotes confidence among employees to\r\nshare their feelings, concerns and wants.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Learning and career development</span></b><span lang=\"EN-GB\">\r\n– instils loyalty as individuals who can see a clear pathway to career\r\ndevelopment are more likely to stay and thrive. <o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Management style</span></b><span lang=\"EN-GB\">\r\n– an organisation should aim to cultivate a ‘leadership’ style of management,\r\nwhere managers lead and help their subordinates to grow, learn and develop\r\nconfidence.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Managing expectations</span></b><span lang=\"EN-GB\">\r\n– it’s important to be honest, measured and honest about what is expected, and\r\nnot impose unrealistic goals on over stretched employees.&nbsp; Employees will comply, and simply plan their\r\nexit.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><b><span lang=\"EN-GB\">Measuring employee attitude</span></b><span lang=\"EN-GB\">\r\n– Regular anonymous surveys are a useful tool to regularly gauge workers\r\nattitude to the organization, and how they feel about the culture and the way\r\nthe business is run. Using this information in an active or rather that passive\r\nway is a good way to generate a healthy culture.<o:p></o:p></span></p><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p><p class=\"MsoListParagraphCxSpLast\" style=\"margin-left:54.0pt;mso-add-space:auto;\r\ntext-indent:-18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">The recruitment process - is often the\r\nfirst interaction between a manager and a new employee and can form the\r\nfoundation of the phycological contract. It is useful at interview for a\r\nmanager to honestly represent what is expected, and e.g., If a representation\r\nthat people employed within this role progress to the next more senior level\r\nwithin 2 years, is not followed through this would likely erode trust in the\r\norganisation, and lead to higher attrition rates.<o:p></o:p></span></p>', 'The term\r\n\'psychological contract\' refers to individuals\' expectations, beliefs, ambitions\r\nand obligations, as perceived by the employer and the...', 4, 1, 'published', NULL, '2025-09-10 05:04:34', '2025-09-10 05:04:34', NULL),
(6, 'Control the quality of your stock', 'control-the-quality-of-your-stock', '<p style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\">quality of the finished product.</p><p style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\">Efficient stock control should incorporate&nbsp;<strong style=\"border: 0px; font-style: inherit; font-variant: inherit; font-weight: bold; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit;\">stock tracking&nbsp;</strong>and&nbsp;<strong style=\"border: 0px; font-style: inherit; font-variant: inherit; font-weight: bold; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit;\">batch tracking</strong>. This means being able to trace a particular item backwards or forwards from source to finished product, and identifying the other items in the batch.</p><p style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\">Goods should be checked systematically for quality, faults identified and the affected batch weeded out. This will allow you to raise any problems with your supplier and at the same time demonstrate the safety and quality of your product.</p><p style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\">With a good computerised stock control system, this kind of tracking is relatively straightforward. Manual stock control methods can also use&nbsp;<strong style=\"border: 0px; font-style: inherit; font-variant: inherit; font-weight: bold; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit;\">codes</strong>&nbsp;to systematise tracking and make it easier to trace particular batches.</p><p style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\">Radio Frequency Identification (RFID) can be used to store information about a product or component\'s manufacturing date, to ensure that it is sold or processed in time. The system can also be used to trace faulty products quickly and efficiently. See the page in this guide on using RFID for inventory control, stock security and quality management.</p>', 'quality of the finished product.Efficient stock control should incorporate&nbsp;stock tracking&nbsp;and&nbsp;batch tracking. This means being able to...', 2, 1, 'published', NULL, '2025-09-10 12:44:23', '2025-09-10 12:44:23', NULL),
(7, 'Stock security Control', 'stock-security-control', '<h3 style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\" class=\"\"><span style=\"font-weight: normal;\">Goods hhg</span></h3><h3 style=\"margin-bottom: 15px; border: 0px; font-variant-numeric: inherit; font-variant-east-asian: inherit; font-variant-alternates: inherit; font-variant-position: inherit; font-variant-emoji: inherit; font-stretch: inherit; font-size: 13px; line-height: inherit; font-family: Arial, Helvetica, sans-serif; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; color: rgb(119, 111, 101);\" class=\"\"><span style=\"font-weight: normal;\">hghg<br></span><h3 class=\"\"><span style=\"font-weight: normal;\">Keeping stock secure depends on knowing what you have, where it is located and how much it is worth - so good records are essential. Stock that is portable, does not feature the business\' logo, or is easy to sell on, is at particular risk.<br>Thieves and shoplifters<br>A thief coming in from outside is an obvious threat. Check the security around your premises to keep the risk to a minimum. In a store, thieves may steal in groups - some providing a distraction while others take goods. Teach your staff to be alert and to recognise behaviour like this. Set up a clear policy and make sure staff are trained in dealing with thieves.<br>Offering to help a customer if you are suspicious will often prevent a theft. Avoid using confrontational words like \"steal\" if you do have to approach a suspected thief, and avoid getting into a dangerous situation.<br>Protect your stock</span><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Identify and mark expensive portable equipment (such as computers). If possible, fit valuable stock with security tags - such as Radio Frequency Identification tags - which will sound an alarm if they are moved.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Don\'t leave equipment hanging around after delivery. Put it away in a secure place, record it and clear up packaging. It is a good idea to dispose of packaging securely -leaving boxes in view could be an advertisement to thieves.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Take regular inventories.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Put CCTV in parking lots and other key locations.</span></li></ul><span style=\"font-weight: normal;\">Theft by staff<br>Theft by employees can sometimes be a problem. To prevent this:</span><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Train staff about your security systems and your disciplinary policies and procedures. Training about the cost of stock theft will help, as many people aren\'t aware of the implications for company turnover and job security.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Set up procedures to prevent theft. Staff with financial responsibilities should not be in charge of stock records.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"padding-left: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Restrict access to warehouses, stockrooms and stationery cupboards.</span></li></ul><ul style=\"margin-bottom: 15px; border: 0px; font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; list-style: none;\"><li style=\"font-style: inherit; font-variant: inherit; font-stretch: inherit; font-size: inherit; line-height: inherit; font-family: inherit; font-optical-sizing: inherit; font-size-adjust: inherit; font-kerning: inherit; font-feature-settings: inherit; font-variation-settings: inherit; padding-left: 15px; border: 0px; list-style: none; background: url(&quot;/cassette.axd/file/feuil/themes/web/images/entre/bullet-list-510d6d670894aa6323f5cedfb9bf2cbc01389418.png&quot;) 0px 1px no-repeat;\"><span style=\"font-weight: normal;\">Regularly change staff controlling stock to avoid collusion or bad practice.</span></li></ul></h3></h3>', 'Goods hhghghgKeeping stock secure depends on knowing what you have, where it is located and how much it is worth - so good records are essential....', 2, 1, 'published', NULL, '2025-09-10 13:12:01', '2025-09-11 17:43:59', 'Clite Mutale (BBA, MBA, MCIPS)'),
(8, 'Central stores training for FY 2025 Develiopment agenda', 'central-stores-training-for-fy-2025-develiopment-agenda', '<p><p><br></p><img src=\"assets/images/68c283a1c3fe8.png\" alt=\"PAB Logo.png\" style=\"max-width: 100%; width: 100%;\"></p><p>Well to central stores training at Padenga&nbsp;</p>', 'Well to central stores training at Padenga&nbsp;', 1, 1, 'published', NULL, '2025-09-11 08:09:05', '2025-09-11 14:33:46', 'Clite Mutale (BBA, MBA, MCIPS)'),
(9, 'invoice', 'invoice', '<img src=\"assets/images/68c285522f673.JPG\" alt=\"Invoice Tony waite.JPG\" style=\"max-width: 100%; width: 50%;\"><p>good news for alll</p>', 'good news for alll', 1, 1, 'published', NULL, '2025-09-11 08:16:18', '2025-09-11 14:50:06', 'clite'),
(10, 'Explain what a ‘bureaucratic’ management style is. What are the advantages and disadvantages of this?', 'explain-what-a-bureaucratic-management-style-is-what-are-the-advantages-and-disadvantages-of-this-', '<p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">A\r\nbureaucratic management style,<b> made popular by Weber in the 1970s, </b>is\r\nlargely based on a <b>Hierarchical Management Structure</b>, in other words, it\r\nis a <b>based on a pyramid type structure</b> whereby there is a single or a\r\nsmall number of very senior managers at the top of the pinnacle.&nbsp; Power, influence, and decision making mainly\r\nstarts at the top, and flows down.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">Bureaucracy\r\nbecame <b>popular in the 1970s</b> when there was a growing desire for a more <i>bureaucratic</i>\r\napproach to doing business.&nbsp; The 70s were\r\nlargely an era of discontent among the workforce, and consequently there was an\r\nincrease in industrial action/strikes and distrust in leadership and politics\r\ngenerally.&nbsp; From this backdrop emerged a\r\nnumber of movements to push equal rights and e.g., women’s rights began to\r\nbecome more mainstream. <o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">At the\r\nsame time, companies were getting bigger, more complex resulting in a practical\r\nneed for more fair, rational and logical organisational structures.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Main\r\nfeatures include: - <o:p></o:p></span></b></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Specialisation</span></b><span lang=\"EN-GB\">\r\n– Division of role and responsibilities among the workers is rigid and highly\r\ndefined.&nbsp; Each person will have their own\r\nset responsibilities, any action taken outside of this will be with express\r\napproval or request of the ‘responsible person’.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">System of\r\nRules</span></b><span lang=\"EN-GB\"> e.g., Formal Written Communication/governance\r\n– with the exception of small and routine activities, most actions will need to\r\nconform to set guidelines on procedures/processes.&nbsp; Anything of consequence will require sign off\r\nand approval.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Impersonality</span></b><span lang=\"EN-GB\">\r\n– linked to uniformity, rules apply equally to everyone. On the one hand this\r\nmay be regarded as equitable, but it limits utilisation of individual talent\r\nand innovation.&nbsp; <o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Rationality</span></b><span lang=\"EN-GB\">\r\n– Each individual will have a clearly defined span of control, which will be\r\noutlined in their job descriptions, there will be little or no freedom to step\r\noutside of this zone.&nbsp; Which again can\r\nlimit growth and innovation.&nbsp; Good\r\n‘ideas’ will struggle to see the light.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Technical\r\nAbility</span></b><span lang=\"EN-GB\"> – Promotion will mainly be based on education\r\nand training which is good in the sense that it removes ‘favouritism’, but it\r\ncould have the effect of inhibiting raw talent or creativity.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Stability</span></b><span lang=\"EN-GB\">\r\n– whilst this structure is quite rigid, it does tend to lead to high levels of\r\nstability, which is why it is still favoured amongst public sector or larger\r\nmore traditional organisations.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><b><span lang=\"EN-GB\">Advantages\r\nof Bureaucracy</span></b><span lang=\"EN-GB\"> <o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:36.0pt\"><span lang=\"EN-GB\">Bureaucracy\r\nis often ridiculed and can carry a number of negative connotations, however as\r\nan approach it does have a number of advantages namely: -<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Bureaucracy is an organisational\r\nstructure characterised by rules, standardised processes, meticulous division\r\nof labour and clear hierarchies, this does lead to it being a <b>‘fairer’\r\nsystem</b>. <o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">It is <b>logical and easy to implement</b>,\r\neveryone knows their role and place, people are in roles and don’t go outside\r\nof those roles- plays to strengths of individuals.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpLast\" style=\"margin-left:54.0pt;mso-add-space:auto;\r\ntext-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Clear written rules mean <b>little\r\nconfusion and room for misinterpretation</b>.<o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-left:72.0pt;text-indent:-36.0pt\"><b><span lang=\"EN-GB\">Disadvantages\r\nof Bureaucracy <o:p></o:p></span></b></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Inflexible – due to overly\r\nprescriptive roles and responsibilities.&nbsp;\r\nAn individual can’t simply implement a good idea… everything will be\r\nrequired to go through the ‘appropriate channels.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Managers may be unresponsive and\r\nbecome bottlenecks… slowing down progress.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Excessive paperwork – most action will\r\nneed to be logged and recorded, and approvals will regularly be required.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Too many layers of hierarchy can make\r\ncommunication ineffective and inefficient – ‘left hand may end up not knowing\r\nwhat the right hand is doing’ across different areas of the business. <o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Inefficient and may lead to siloed\r\nworking, <o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-left:54.0pt;mso-add-space:\r\nauto;text-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Doesn’t consider the human need for\r\npersonal relationships and empowerment and employees may lose patience, if they\r\nperceive that career advancement opportunity are few and far between. <o:p></o:p></span></p><p>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n</p><p class=\"MsoListParagraphCxSpLast\" style=\"margin-left:54.0pt;mso-add-space:auto;\r\ntext-indent:-18.0pt;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span lang=\"EN-GB\">-<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-size-adjust: none; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-variant-position: normal; font-variant-emoji: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n</span></span><!--[endif]--><span lang=\"EN-GB\">Not suitable for customer facing roles,\r\nwhere problems need to be dealt with in real time.<o:p></o:p></span></p>', 'A\r\nbureaucratic management style, made popular by Weber in the 1970s, is\r\nlargely based on a Hierarchical Management Structure, in other words,...', 4, 1, 'published', NULL, '2025-09-11 13:18:27', '2025-09-13 05:10:34', 'Clite Mutale'),
(11, 'Welcome', 'welcome', '<p>You are welcome to mutalex</p>', 'You are welcome to mutalex', 1, 1, 'published', NULL, '2025-09-11 14:23:23', '2025-09-11 14:23:23', 'Clite Mutale (BBA, MBA, MCIPS)'),
(12, 'communicationn', 'communicationn', '<img src=\"assets/images/690b7a0d0cefa.png\" alt=\"Gemini_Generated_Image_e597yne597yne597.png\" style=\"max-width:100%;\"><p><br></p><p>good communication&nbsp;</p>', 'good communication&nbsp;', 6, 1, 'published', NULL, '2025-11-05 16:23:41', '2025-11-05 16:23:41', 'Clite Mutale (BBA, MBA, MCIPS)'),
(13, 'quality control', 'quality-control', '<img src=\"assets/images/690b7a53874b7.png\" alt=\"Gemini_Generated_Image_3psg7p3psg7p3psg.png\" style=\"max-width:100%;\"><p><br></p><p><br></p><p>keep quality food in the warehouse</p>', 'keep quality food in the warehouse', 6, 1, 'published', NULL, '2025-11-05 16:24:51', '2025-11-05 16:24:51', 'Clite Mutale (BBA, MBA, MCIPS)');
INSERT INTO `posts` (`id`, `title`, `slug`, `content`, `excerpt`, `category_id`, `author_id`, `status`, `featured_image`, `created_at`, `updated_at`, `manual_author_name`) VALUES
(14, 'sustainability', 'sustainability', '<p style=\"margin-left: 25px;\">Good sustainability practice, will be good for the business.&nbsp;</p><ol><li><li><li><li><li><li><li><li><li><ol><li><ol><li style=\"margin-left: 25px;\"><ol><li style=\"text-align: left; margin-left: 25px;\">hhghhghghghkkg&nbsp;</li><li style=\"text-align: left; margin-left: 25px;\">ghhhhh</li><li style=\"text-align: left; margin-left: 25px;\">hh</li><li style=\"text-align: left; margin-left: 25px;\">jgjgjgjgjg</li><li style=\"text-align: left; margin-left: 25px;\">hhhmmh</li><li style=\"text-align: left; margin-left: 25px;\">hhh</li><li style=\"text-align: left; margin-left: 25px;\">hghghg</li></ol></li></ol></li></ol></li></li></li></li></li></li></li></li></li></ol>', 'Good sustainability practice, will be good for the business.&nbsp;hhghhghghghkkg&nbsp;ghhhhhhhjgjgjgjgjghhhmmhhhhhghghg', 6, 1, 'published', NULL, '2025-11-06 14:10:44', '2025-11-06 14:14:12', 'Clite Mutale (BBA, MBA, MCIPS)');

-- --------------------------------------------------------

--
-- Table structure for table `site_settings`
--

CREATE TABLE `site_settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `site_settings`
--

INSERT INTO `site_settings` (`id`, `setting_key`, `setting_value`, `created_at`, `updated_at`) VALUES
(1, 'site_logo', 'assets/images/logo_1757657555.jpg', '2025-09-12 00:25:26', '2025-09-12 06:12:35'),
(2, 'site_name', 'Mutalex Academy', '2025-09-12 00:25:26', '2025-09-12 00:25:26'),
(8, 'slideshow_images', '[{\"url\":\"assets\\/images\\/slideshow\\/slide_1762364390_1043.png\",\"title\":\"\",\"description\":\"\",\"source\":\"upload\"},{\"url\":\"assets\\/images\\/slideshow\\/slide_1762364409_6828.png\",\"title\":\"\",\"description\":\"\",\"source\":\"upload\"},{\"url\":\"assets\\/images\\/slideshow\\/slide_1762377421_6489.png\",\"title\":\"\",\"description\":\"\",\"source\":\"upload\"},{\"url\":\"assets\\/images\\/slideshow\\/slide_1762431494_1056.png\",\"title\":\"good news for mutalex\",\"description\":\"great comes with hardworking.\",\"source\":\"upload\"}]', '2025-11-05 17:10:05', '2025-11-06 12:18:14');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','author') DEFAULT 'author',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `role`, `created_at`) VALUES
(1, 'admin', 'admin@blog.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', '2025-09-10 03:45:35');

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `session_token` varchar(255) NOT NULL,
  `expires_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `announcements`
--
ALTER TABLE `announcements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `categories`
--
ALTER TABLE `categories`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`),
  ADD UNIQUE KEY `slug` (`slug`);

--
-- Indexes for table `posts`
--
ALTER TABLE `posts`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `slug` (`slug`),
  ADD KEY `category_id` (`category_id`),
  ADD KEY `author_id` (`author_id`);

--
-- Indexes for table `site_settings`
--
ALTER TABLE `site_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `announcements`
--
ALTER TABLE `announcements`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `categories`
--
ALTER TABLE `categories`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `posts`
--
ALTER TABLE `posts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=15;

--
-- AUTO_INCREMENT for table `site_settings`
--
ALTER TABLE `site_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `announcements`
--
ALTER TABLE `announcements`
  ADD CONSTRAINT `announcements_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `posts`
--
ALTER TABLE `posts`
  ADD CONSTRAINT `posts_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `posts_ibfk_2` FOREIGN KEY (`author_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
